import java.awt.*;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/* Sets up all the graphics such as logo and text
** for the about window.
*/
class AboutDrawPanel extends JPanel
{
    public void paintComponent(Graphics g)
    {
        super.paintComponent(g);
		int cx, cy;
		logo = Toolkit.getDefaultToolkit().getImage("logo.gif");
        font = new Font("SansSerif", Font.PLAIN, 14);
        fm = g.getFontMetrics(font);
		text1 = "User Extensible System Architecture";
		text2 = "UESA is a processor simulator entirely";
		text3 = "written using JAVA 1.2.2";

		//Draw and position logo and text
		cy = fm.getHeight();
		g.setFont(font);
        g.drawImage(logo, CentreObject.centreonaxis(300, Prefs.getBigLogoX()), 0, null);
		cx = fm.stringWidth(text1);
        g.drawString(text1, CentreObject.centreonaxis(300, cx),Prefs.getBigLogoY()+cy);
		cx = fm.stringWidth(text2);
		g.drawString(text2, CentreObject.centreonaxis(300, cx),Prefs.getBigLogoY()+cy*2);
		cx = fm.stringWidth(text3);
		g.drawString(text3, CentreObject.centreonaxis(300, cx),Prefs.getBigLogoY()+cy*3);
		
    }
    private Image logo;
	private Font font;
	private FontMetrics fm;
	private String text1;
	private String text2;
	private String text3;
}
