import java.awt.*;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/* Creates the window where the user can define instructions.
** Also defines various gadgets the window requires
*/

class DefInstWin extends JDialog implements ActionListener
{
	public DefInstWin(JFrame parent)
	{
		super(parent, "Instruction Definition", true);
		grandparent = parent;

		model = new DefaultListModel();
		JList instructionlist = new JList(model);
		
		//Setup panels for gadgets
		contentpane = getContentPane();
		JPanel panel = new JPanel();
		JPanel panel2 = new JPanel();
		JPanel panel3 = new JPanel();
		confirmgadgets = new JPanel();
		JScrollPane scroll = new JScrollPane(instructionlist);
		buildInstructionList();
		//Setup window positioning and size
		setBounds(CentreObject.centreonaxis(Prefs.getScrW(), 350), CentreObject.centreonaxis(Prefs.getScrH(), 250), 350, 250);

		//Create Textfiels and add them to a panel
		panel.setLayout(new GridLayout(2, 2));
		panel.add(new JLabel("Command Name:"));
		panel.add(instname = new JTextField("",10));
		panel.add(new JLabel("RTL Definition",10));
		panel.add(RTLdef = new JTextField(""));
		panel2.add(addButton = new JButton("ADD INSTRUCTION"));
		panel3.setLayout(new BorderLayout(5, 5));
		panel3.add("North", new JLabel("Current Instruction Set"));
		panel3.add("Center", scroll);

		confirmgadgets.add(okButton = new JButton("OK"));
        okButton.addActionListener(this);
		addButton.addActionListener(this);
		contentpane.add("North", panel);
		contentpane.add("West", panel2);
		contentpane.add("Center", panel3);
		contentpane.add("South", confirmgadgets);
	}

	/* Method to listen for and events generated by gadgets
	** and act upon them
	*/
    public void actionPerformed(ActionEvent evt)
    {
        Object source = evt.getSource();
        
		if (source == okButton)
        {
            setVisible(false);
        }
		else
		{
			int instnum, x=1;
			String teststr;
			boolean exists=false;
			Instruction cmd=null;
		
			instnum = Prefs.getNumInst();

			while (exists==false && x < instnum+1)
			{
				cmd = Prefs.getInst(x);
				teststr=cmd.getName();
				if(instname.getText().trim().equals(teststr))
				{
					exists=true;
				}
				x++;
			}

			if ( exists == false)
			{ parseRTL();	}
			else
			{ JOptionPane.showMessageDialog(grandparent, "An instruction of that name already exists!", "Instruction Duplication", JOptionPane.WARNING_MESSAGE); }
		}
	}

	private void parseRTL()
	{
		String rtlstr;
		String instn;
		int len;
		char ch;
		int[] flst = new int[5];
		int[] olst = new int[5];
		int fptr = 0;
		int optr = 0;
		
		rtlstr = RTLdef.getText().trim();
		instn = instname.getText().trim();
		model.addElement(instn);
		len = rtlstr.length()-1;
		
		while (len > -1)
		{
			ch = rtlstr.charAt(len);
			
			switch (ch)
			{
				case ' ':
					len--;
					break;
				case '[':
					len--;
					break;
				case ']':
					len--;
					break;
				case 'A':
					olst[optr]=ADDRREG;
					optr++;
					len--;
					break;
				case 'D':
					olst[optr]=DATAREG;
					optr++;
					len--;
					break;
				case 'M':		
					olst[optr]=MEMLOCA;
					optr++;
 					len--;
					break;
				case '+':
					flst[fptr]=ADD;
					fptr++;
					len --;
					break;
				case '-':
					len --;
					ch = rtlstr.charAt(len);
					if (ch == '<')
					{
						flst[fptr]=MOV;
						fptr++;
						len--;
					}
					else
					{
						flst[fptr]=SUB;
						fptr++;
					}					
					break;
				case '*':
					flst[fptr]=MUL;
					fptr++;
					len --;
					break;
				case '/':
					flst[fptr]=DIV;
					fptr++;
					len --;
					break;
				case '#':
					olst[optr]=LITERAL;
					optr++;
					len --;
					break;
				default:
					len--;
					System.out.println("UNKNOWN CHAR");
					break;		
			}			
		}

		Prefs.newInst(instn, optr, fptr, olst, flst);
		RTLdef.setText("");
		instname.setText("");
	}

	private void buildInstructionList()
	{
		int instnum, x=1;
		Instruction cmd=null;		
		instnum = Prefs.getNumInst();

		while (x < instnum+1)
		{
			cmd = Prefs.getInst(x);
			model.addElement(cmd.getName());
			x++;
		}
	}

	private JFrame grandparent;
	private DefaultListModel model;
	private JButton okButton;
	private JButton addButton;
	private Container contentpane;
	private JPanel confirmgadgets;
	private JTextField instname;
	private JTextField RTLdef;
	private final int ADD = 0;
	private final int SUB = 1;
	private final int MUL = 2;
	private final int DIV = 3;
	private final int MOV = 4;
	private final int JMP = 5;
	private final int BGT = 6;
	private final int BLT = 7;
	private final int BNE = 8;
	private final int LITERAL = 0;
	private final int DATAREG = 1;
	private final int ADDRREG = 2;
	private final int MEMLOCA = 3;
	private final int LABEL = 4;
}

