import java.awt.*;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/* Creates the window for configuring the memory settings
*/
class DefMemoryWin extends JDialog implements ActionListener
{
	public DefMemoryWin(JFrame parent)
	{
		super(parent, "Memory Size Definition", true);
		
		//Setup panels for gadgets
		Container contentpane = getContentPane();
		Panel confirmgadgets = new Panel();
		JPanel panel = new JPanel();
		
		//Setup window positioning and size.
		setBounds(CentreObject.centreonaxis(Prefs.getScrW(), 300), CentreObject.centreonaxis(Prefs.getScrH(), 85), 300, 85);
		setResizable(false);

		panel.setLayout(new GridLayout(1, 2));
		panel.add(new JLabel("Memory Size (blocks):"));
        panel.add(memText = new JTextField("0"));
		contentpane.add("Center", panel);
		
		//Create gadgets and add to a listener where necessary
		

        confirmgadgets.add(okButton = new JButton("OK"));
		
		
        confirmgadgets.add(cancelButton = new JButton("CANCEL"));
		
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        contentpane.add("South", confirmgadgets);
	}

	/* Method to act on events generated by gadgets and
	** close the window.
	*/	
   	public void actionPerformed(ActionEvent evt)
    {
        Object source = evt.getSource();
        if (source == okButton)
        {
            setVisible(false);
            status = true;
        }
        else
        {
            setVisible(false);
            status = false;
        }
    }

	/* Method to initialise the textfield on the window
	** before opening. Once the window has closed it will
	** set the appropriate memory preference if necessary
	*/
    public void showDia()
    {
        memText.setText(Prefs.getMemSize());
        show();
        if (status==true)
        {
            Prefs.setMemSize(memText.getText());
        }
    }

	private boolean status;
	private JTextField memText;
	private JButton okButton;
	private JButton cancelButton;

}
