import java.awt.*;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


/* Creates the window where the user defines the number
** and width of registers.
*/
class DefRegWin extends JDialog implements ActionListener
{
    public DefRegWin(JFrame parent)
    {
        super(parent, "Register Definition", true);

		//Create panels for gadgets
        Container contentpane = getContentPane();
		JPanel panel = new JPanel();
        JPanel text = new JPanel();
		Box radio = Box.createHorizontalBox();
        Panel confirmgadgets = new Panel();

		//Setup window positioning and size
        setBounds(CentreObject.centreonaxis(Prefs.getScrW(), 300), CentreObject.centreonaxis(Prefs.getScrH(), 150), 300, 150);
		setResizable(false);

		//Create buttons and add them to a panel
		panel.setLayout(new GridLayout(2, 1));
        ButtonGroup group = new ButtonGroup();
        group.add(size16 = new JRadioButton("16bit", false));
        group.add(size32 = new JRadioButton("32bit", true));
        
		//Create textfields and add them to a panel
		text.setLayout(new GridLayout(2, 2));
        text.add(new JLabel("Data Registers:"));
        text.add(dregText = new JTextField(dregnum));
        text.add(new JLabel("Address Registers:"));
        text.add(aregText = new JTextField(aregnum));

		//Create Radio buttons and add them to a panel
		radio.add(new JLabel("Register Size:     "));
		radio.add(size16);
		radio.add(size32);
		panel.add(text);
		panel.add(radio);
        contentpane.add("Center", panel);

        confirmgadgets.add(okButton = new JButton("OK"));
        confirmgadgets.add(cancelButton = new JButton("CANCEL"));
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        contentpane.add("South", confirmgadgets);
    }

	/* Method to listen to events generated by gadgets and
	** act upon them. Also closes the window
	*/
    public void actionPerformed(ActionEvent evt)
    {
        Object source = evt.getSource();
        
		if (source == okButton)
        {
            setVisible(false);
            status = true;
        }
        else
        {
            setVisible(false);
            status = false;
        }
	
    }

	/* Displays the window, then once the window has closed it sets
	** the register preferences, if necessary
	*/
    public void showDia()
    {
        dregText.setText(Prefs.getDreg());
        aregText.setText(Prefs.getAreg());
        show();
        if (status==true)
        {
            Prefs.setRegisters(aregText.getText(), dregText.getText());
        }
    }

    private String aregnum;
    private String dregnum;
    private boolean status;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField dregText;
    private JTextField aregText;
	private JRadioButton size16;
	private JRadioButton size32;

}
