
import java.awt.*;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;


/* Actually executes the source code and outputs any messages to the
** listview on the Run Source Window
*/
class ParseSource
{
	public ParseSource (String fname, DefaultListModel model, Register[] al, Register[] dl,CCR concoreg)
    {
  		int m = 0;
		filename = fname;
		System.arraycopy(dl, 0 , dreglist, 0, 32);
		System.arraycopy(al, 0 , areglist, 0, 32);
		ccr = concoreg;

		for (m = 0; m < 4096; m++)
		{
			memlist[m] = new MemoryLocation();
		}

		output=model;

		stk = new MyStack();
		stk.Stack(20);

		say("***Executing "+filename+"...");
		try
		{
			fin  = new BufferedReader (new FileReader(filename));
			fin.mark(1000);
		}
		catch (Exception e)
		{
			System.out.println("Warning: Exception Generated.");
		}
    }

	public void go()
	{

       try
        {		
            while(true==true)
            {

				inststate=0;
				line++;


				//Get a new line of text from source
                str=returnline(fin);

				//Get length of string                
                len=str.length();
				//len=len-1;                
				
				//Reset x to zero for new line
                x=0;

				//Return character int string str at position x
                ch=returnchar(str,x);

				while(x < (len) )
                {

                    switch (ch)
                    {
                        case ';':
							parseComment();
                            break;

                        case ' ':
							parseSpace();
                            break;

                        case ':':
							labelError();
                            break;

                        default:
							c = new Character(ch);
							tempstr = tempstr+c;
							parseDefault();
                            break;

                    }

                }

            }

        }
        catch(Exception e)
        {

			say("***End ");
        }
		closeFile();        
	}

	public void step()
	{
       try
        {		

				inststate=0;
				line++;

				//Get a new line of text from source
                str=returnline(fin);

				//Get length of string                
                len=str.length();
				//len=len-1;                
				
				//Reset x to zero for new line
                x=0;

				//Return character int string str at position x
                ch=returnchar(str,x);

				while(x < (len) )
                {

                    switch (ch)
                    {
                        case ';':
							parseComment();
                            break;

                        case ' ':
							parseSpace();
                            break;

                        case ':':
							labelError();
                            break;

                        default:
							c = new Character(ch);
							tempstr = tempstr+c;
							parseDefault();
                            break;

                    }

                }


        }
        catch(Exception e)
        {
			say("***End ");
        }

	}

	public void closeFile()
	{
		try
		{ fin.close(); }
		catch(IOException e)
		{ System.out.println("Unable to close file");}
	}

	/* Collects the digits together for an operand, converts
	** them to an integer and places it on the stack
	*/
	private void parseOperand(char optype)
	{
		String convtonum="";

		while (ch !=',' && x<(len-1))
		{
			x++;
            ch=returnchar(str,x);
			if (ch !=',')
			{
				c = new Character(ch);
				convtonum=convtonum +c;
			}
		}

		switch (optype)
		{
			case 'A':
				if (StringToInt.strToInt(convtonum)>StringToInt.strToInt(Prefs.getAreg())-1)
				{ say("***Error: Address Register out of range"); }
				break;
			case 'D':
				if (StringToInt.strToInt(convtonum)>StringToInt.strToInt(Prefs.getDreg())-1)
				{ say("***Error: Data Register out of range"); }
				break;
			case '$':
				if (StringToInt.strToInt(convtonum)>StringToInt.strToInt(Prefs.getMemSize())-1)
				{ say("***Error: Memory Location out of range"); }
				break;
		}
	
		stk.push(StringToInt.strToInt(convtonum));
		convtonum="";

	}

	/*Parse the operand set and breaks it up into individual
	** operands. It knows about the number of operands an
	** instruction should have, and detects the number of
	** operands actually used in the source by detecting
	** the commas.
	*/
	private void parseOperandSet (Instruction cmd)
	{
		int operandnum=cmd.getNumOps();
		int numparsed=0;		

		while(x < (len-1) && numparsed < operandnum)
		{
			x++;									
            ch=returnchar(str,x);
			
			switch (ch)
			{
				case 'A':
					parseOperand('A');
					numparsed++;
					break;

				case 'D':
					parseOperand('D');
					numparsed++;
					break;

				case '#':
					parseOperand('#');
					numparsed++;
					break;

				case '$':
					parseOperand('$');				
					numparsed++;
					break;

				case ' ':
					break;		
			
				default:
					say("***Errors with Instruction Operands");
					break;
			}

		}
			
		execute(cmd);
	}

	/* Displays the comment to the screen and jumps to the
	** end of line, in preperation for reading the next
	** line
	*/
	private void parseComment()
	{
		i = new Integer(line); 
		say(str);		
        x=len+1;
	}

	/* Simply ignores whitespace space characters
	*/
	private void parseSpace()
	{
		x++;
        ch=returnchar(str,x);
	}

	/* Ouputs an error to say that a label has been
	** detected without a name
	*/
	private void labelError()
	{
		i = new Integer(line);
		say(str);
		say("***Error: Label with no name at line "+i); 
        x=len+1;
	}

	/* Simple method to output a string to the list on
	** the run source window.
	*/
	private void say(String s){output.addElement(s);}

	/* Sends the string to checkCommand to see if it is
	** an instruction that exists. If not it outputs an
	** error, otherwise it hands the instruction over
	** for operand parsing.
	*/
	private void parseCommand()
	{
		Instruction cmd;

		i = new Integer(line);
		say(str);									
		
		cmd=checkCommand(tempstr);
		tempstr="";
		
		if (cmd != null)
		{
			parseOperandSet(cmd);
		}
		else
		{
			say("***Unknown Instruction");
		}			
	}
	
	/* Displays the label to the screen and adds it to the
	** label array for future use. Currently labels are not
	** used for branching
	*/
	private void parseLabel()
	{
		i = new Integer(line);
		say(tempstr);
		labellist[numlabel] = new Label(tempstr, line);
		numlabel++;
		say("***Label Detected at line "+i);
		tempstr="";
	}

	/* Reads characters from the file until a terminating 
	** space is found. It then determines whether the string
	** is a Mnemonic or a label)
	*/
	private void parseDefault()
	{
		while (inststate==0)
        {
        	x++;
            ch=returnchar(str,x);
			if (ch !=' ')
			{
				c = new Character(ch);
				tempstr = tempstr +c;
			}
            inststate=insthandle(ch);
        }

        if (inststate==1)
        {
			parseCommand();				
        }
        else
        {
			parseLabel();
        }

        x=len+1;
	}

    /*
    **  Reads in a line of text from the specified
    **  BufferedReader and returns it.
    */
    private static String returnline(BufferedReader fin)
    {
        String str="";
        try
        {
            str=fin.readLine();
        } 
        catch(Exception e)
        {
            System.out.println("***End");
			
        }
        return str;
    } 

    /*
    **  Returns the character at position X in a string.
    **  Checks if the position is out of bounds and
    **  returns an error msg if thats the case.
    */
    public static char returnchar(String mystr, int x)
    {
        char ch='!';

        if (x>mystr.length())
        {
        	System.out.println("String Out of Range");
        }
        else
        {
            ch=mystr.charAt(x);
            
        } 
        return ch; 
    } 

    /*
    **  Checks whether the next character is a space,
    **  colon or other character. Instructions are
    **  terminated with :, commands terminated with space
    */
    private static int insthandle(char ch)
    {
        int val=0;
        switch (ch)
        {
            case ' ': //Must Be a Command
                val=1;
                break;
            case ':': //Must Be a Label
                val=2;
                break;
            default: // Read Another Character
                val=0;
                break;
        }
        return val;          
    }

	/* Checks to see whether the command does exist
	** and has been defined. It does this by comparing
	** the Mnemonic from the source to the one in the
	** instruction array. If it does exist, it returns
	** the command
	*/
	private Instruction checkCommand(String s)
	{
		int instnum, x=1;
		String teststr;
		boolean exists=false;
		Instruction cmd=null;
		
		instnum = Prefs.getNumInst();

		while (exists==false && x < instnum+1)
		{
			cmd = Prefs.getInst(x);
			teststr=cmd.getName();
			if(s.equals(teststr))
			{
				exists=true;
			}
			x++;
		}

		if ( exists == false)
		{
			cmd = null;
		}
		return cmd;
	}
   
	/* Executes an instruction by pulling the operands off the stack,
	** and obtaining their datatypes by looking at the instructions
	** operand array. The functions performed on those operands and are
	** done by looking in the instructions function array.
	*/
	private void execute(Instruction cmd)
	{
		//Pointer to element in operand array
		opptr = 0;	
		int numberofoperands = cmd.getNumOps();
		int numberoffuncs = cmd.getNumFunc();
		//funcptr is a pointer to element in function array
		int functype = 0, funcptr = 0, val1, val2;
		int[] flst = cmd.getFuncList();
		int[] olst = cmd.getOpList();
		//Set to true if the result of a function has been placed
		//on the stack to be used in the next.
		boolean resonstack=false;
		onstacktype=0;

		//Cycles through the function array executing each function
		//in turn
		for (funcptr = 0; funcptr<numberoffuncs; funcptr++)
		{
			switch (functype = flst[funcptr])
			{
				//Perform an add function with two operands, in the
				//case where the result of a previous function is
				//on the stack, use that. Put result on stack
				case ADD:
					
					if (resonstack == true)
					{ val1 = resolveValue(onstacktype,false);}
					else
					{ val1 = resolveValue(olst[opptr],true);	}
					
					val2 = resolveValue(olst[opptr],true);
					stk.push(val1 + val2);
					System.out.println(val1+val2);
					resonstack = true;
					onstacktype = LITERAL;
					break;
				//Perform a sub function with two operands, in the
				//case where the result of a previous function is
				//on the stack, use that. Put result on stack
				case SUB:
					if (resonstack == true)
					{ val1 = resolveValue(onstacktype, false); }
					else
					{ val1 = resolveValue(olst[opptr], true);	}
				
					val2 = resolveValue(olst[opptr], true);
					stk.push(val2 - val1);
					resonstack = true;
					onstacktype = LITERAL;
					break;
				//Perform a mul function with two operands, in the
				//case where the result of a previous function is
				//on the stack, use that. Put result on stack
				case MUL:
					if (resonstack == true)
					{ val1 = resolveValue(onstacktype, false); }
					else
					{ val1 = resolveValue(olst[opptr], true);	}
				
					val2 = resolveValue(olst[opptr], true);
					stk.push(val1 * val2);
					resonstack = true;
					onstacktype = LITERAL;
					break;
				//Perform a DIV function with two operands, in the
				//case where the result of a previous function is
				//on the stack, use that. Put result on stack
				case DIV:
					if (resonstack == true)
					{ val1 = resolveValue(onstacktype, false); }
					else
					{ val1 = resolveValue(olst[opptr], true);	}
			
					val2 = resolveValue(olst[opptr], true);
					stk.push(val2 / val1);
					resonstack = true;
					onstacktype = LITERAL;
					break;
				//Perform a move function to a memory location, date or
				//address register. Update the condition code register
				//to reflect the result.
				case MOV:
					if (resonstack==true)
					{ val1 = resolveValue(onstacktype, false);	resonstack=false; }
					else
					{ val1 = resolveValue(olst[opptr], true); }
					val2 = stk.pull();
					switch (olst[opptr])
					{
						case DATAREG:
							dreglist[val2].setValue(val1);
							onstacktype=DATAREG;
							opptr++;
							break;
						case ADDRREG:
							areglist[val2].setValue(val1);
							onstacktype=ADDRREG;
							opptr++;
							break;
						case MEMLOCA:
							memlist[val2].setValue(val1);
							onstacktype=MEMLOCA;
							opptr++;
							break;
					}

					if (val1 == 0)
					{ccr.setZOn();}
					else
					{ccr.setZOff();}

					if (val1 < 0)
					{ccr.setNOn();}
					else
					{ccr.setNOff();}
					resonstack=true;			
					stk.push(val2);
					break;
				//Jump tp a specific line in the source code by resetting
				//the source back to the start and read lines, discarding them,
				//until the jump line is reached.
				case JMP:
					try
					{
						int t, jumpto;

						jumpto = stk.pull();

						fin.reset();
						
						for (t = 0; t<jumpto -1; t++)
						{
							fin.readLine();
						}
						
						line = jumpto - 1;
						ccr.setNOff();
						ccr.setZOff();					
					}
					catch (IOException e)
					{
						System.out.println("Error with Branch");
					}
					break;
				//Set the Z flag if value 1 is greater than value 2
				case SGT:
					val1 = resolveValue(olst[opptr], true);
					val2 = resolveValue(olst[opptr], true);
					
					if (val2 > val1)
					{ccr.setZOn();}
					else
					{ccr.setZOff();}
					ccr.setNOff();
					break;
				//Set the Z flag if value 1 is less than value 2
				case SLT:
					val1 = resolveValue(olst[opptr], true);
					val2 = resolveValue(olst[opptr], true);
					
					if (val2 < val1)
					{ccr.setZOn();}
					else
					{ccr.setZOff();}
					ccr.setNOff();
					break;
				//Check the Z flag and branch if it is zero. BINZ
				//means Branch If Not Zero, i.e. branch if the last
				//instruction did not produce a zero
				case BINZ:
					if (ccr.getZ() == false)
					{
						try
						{
							int t, jumpto;

							jumpto = stk.pull();

							fin.reset();
						
							for (t = 0; t<jumpto -1; t++)
							{
								fin.readLine();
							}
						
							line = jumpto - 1;					
						}
						catch (IOException e)
						{
							System.out.println("Error with Branch");
						}
					}
					ccr.setNOff();
					ccr.setZOff();
					break;
				//Check the Z flag and branch if it is 1. BIZ
				//means Branch If Zero, i.e. branch if the last
				//instruction produced a zero
				case BIZ:
					if (ccr.getZ() == true)
					{
						try
						{
							int t, jumpto;

							jumpto = stk.pull();

							fin.reset();
						
							for (t = 0; t<jumpto -1; t++)
							{
								fin.readLine();
							}
						
							line = jumpto - 1;					
						}
						catch (IOException e)
						{
							System.out.println("Error with Branch");
						}
					}
					ccr.setNOff();
					ccr.setZOff();
					break;
				//Compare function, comparses two values and sets the Z
				//flag if they are equal.
				case CMP:
					val1 = resolveValue(olst[opptr], true);
					val2 = resolveValue(olst[opptr], true);
					if (val1 == val2)
					{ccr.setZOn();}
					else
					{ccr.setZOff();}
					ccr.setNOff();
					break;
			}
		}
	}

	/* Resolves a value obtained from the stack and returns the real value.
	** For example, the number 1 may be on the stack, this could mean a 
	** data register or the literal 1. In the case of a data register it 
	** would obtain the value in D1 and return that as the real value.
	*/
	private int resolveValue(int v, boolean doinc)
	{
		int value = 0;
		
		switch(v)
		{
			//Simply return the raw value
			case LITERAL:
				value = stk.pull();
				onstacktype=LITERAL;
				break;
			//Return the contents of the data register
			case DATAREG:
				value = dreglist[stk.pull()].getValue();
				onstacktype=DATAREG;
				break;
			//Return the contents of a mem location pointed at by the
			//address register
			case ADDRREG:
				value = areglist[stk.pull()].getValue();
				value = memlist[value].getValue();
				onstacktype=ADDRREG;
				break;
			//Return the contents of a memory location.
			case MEMLOCA:
				value = memlist[stk.pull()].getValue();
				onstacktype=MEMLOCA;
				break;
			//Currently - do nothing.
			case LABEL:
				onstacktype=LABEL;
				break;
		}
		//Increment the operand array pointer to the next element.
		if (doinc==true)
		{opptr++;}
		return value;
	}

	/* Displays a memory dump on the "Run Source" window.*/
	public void memoryDump()
	{
		int numloc = StringToInt.strToInt(Prefs.getMemSize())-1;
		int x;
		Integer i, n;
		say("   ");
		say("***Performing Memory Dump...");

		//Cycles through the memory location array and outputs the contents
		//of each memory location.
		for (x = 0; x < numloc+1; x++)
		{
			i = new Integer(x);
			n = new Integer(memlist[x].getValue());
			say("Address: "+i+"     Contents: "+n);			
		}
	}

	private Integer i;
	private int line=0;
	private int onstacktype=0;
	private String str;
	private int len;
	private int x;
	private DefaultListModel output;
	private char ch;
	private Character c;
	private String tempstr="";
	private int inststate=0;
	private MyStack stk;
	private Register[] dreglist = new Register[32];
	private Register[] areglist = new Register[32];
	private MemoryLocation[] memlist = new MemoryLocation[4096];
	private Label[] labellist = new Label[30];
	private int numlabel = 0;
	private int opptr=0;
	private final int ADD = 0;
	private final int SUB = 1;
	private final int MUL = 2;
	private final int DIV = 3;
	private final int MOV = 4;
	private final int JMP = 5;
	private final int SGT = 6;
	private final int SLT = 7;
	private final int BINZ = 8;
	private final int BIZ = 9;
	private final int CMP = 10;
	private final int LITERAL = 0;
	private final int DATAREG = 1;
	private final int ADDRREG = 2;
	private final int MEMLOCA = 3;
	private final int LABEL = 4;
	private BufferedReader fin;
	private CCR ccr;
	private String filename;

}


