import javax.swing.*;
import javax.swing.event.*;

/* Holds the preferences for the entire program. This class is static
** and so only one instance is needed. All preference settings are
** accessed and set using accessors.
*/
public class Prefs
{

	private static int screenwidth=0;
	private static int screenheight=0;
	private static int regsize=32;
	private static int biglogox=237;
	private static int biglogoy=73;
	private static String areg="8";
	private static String dreg="8";
	private static String memsize="10";
	private static String sourcefile="test.s";
	private static Instruction[] instlist = new Instruction[60];
	private static int numinst = 0;

	//Accessors
	public static void setBigLogoX(int x){biglogox = x;}
	public static void setBigLogoY(int y){biglogoy = y;}
    public static void setScreenSize(int sw, int sh){screenwidth = sw; screenheight = sh;}
	public static void setSourceFile(String sf){sourcefile=sf;}	
    public static void setAreg(String a)
	{
		if (StringToInt.strToInt(a) > 32)
		{
			areg="32";
		}
		else
		{

			if (StringToInt.strToInt(a) < 0)
			{
				areg="8";
			}
			else
			{
				areg = a;
			}
		}
	}

	public static void setDreg(String d)
	{


		if (StringToInt.strToInt(d) > 32)
		{
			dreg="32";
		}
		else
		{
			if (StringToInt.strToInt(d) < 1)
			{
				dreg="8";
			}
			else
			{
				dreg = d;
			}
		}
	}

    public static void setRegisters(String a, String d){setAreg(a); setDreg(d);}
	public static void setRegSize(int rs){regsize = rs;}
	public static void setMemSize(String ms)
	{

		if (StringToInt.strToInt(ms) > 4096)
		{
			memsize="4096";
		}
		else
		{
			if (StringToInt.strToInt(ms) < 1)
			{
				memsize="1024";
			}
			else
			{	
				memsize = ms;
			}
		}
	}
	public static int getBigLogoX(){return biglogox;}
	public static int getBigLogoY(){return biglogoy;}
	public static String getSourceFile(){return sourcefile;}
    public static int getScrW(){return screenwidth;}
    public static int getScrH(){return screenheight;}
    public static String getAreg(){return areg;}
	public static String getDreg(){return dreg;}
	public static String getMemSize(){return memsize;}
	public static int getNumInst(){return numinst;}
	
	public static void newInst(String name, int numops, int numfunc, int[] oplist, int[] flst)
	{
		numinst++;
		instlist[numinst] = new Instruction(name, numops, numfunc, oplist, flst);
	}

	public  static Instruction getInst(int i)
	{
		return instlist[i];
	}



}

