import java.awt.*;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/* Setups up the Run Source Window including the gadgets.
*/
class RunSrcWin extends JDialog implements ActionListener
{
	public RunSrcWin(JFrame parent)
	{
		super(parent, "Running Source",true);
		int  aregnum =0, dregnum = 0, x = 0;
		CCR = new CCR();
		model = new DefaultListModel();
		JList outputlist = new JList(model);

		//Get the number of Address and Data Registers
		aregnum = StringToInt.strToInt(Prefs.getAreg());
		dregnum = StringToInt.strToInt(Prefs.getDreg());

		//Setup panels for gadgets
		Container contentpane = getContentPane();
		JPanel dpanel = new JPanel();
		JPanel apanel = new JPanel();
		JPanel lpanel = new JPanel();
		JPanel ypanel = new JPanel();
		JPanel ccrpanel = new JPanel();
		JPanel confirmgadgets = new JPanel();
		JScrollPane scroll = new JScrollPane(outputlist);

		//Set Size of Window
		setSize(Prefs.getScrW(), Prefs.getScrH());

		//Setup Panel Layout Managers
		apanel.setLayout(new GridLayout(aregnum, 2));
		dpanel.setLayout(new GridLayout(dregnum, 2));
		ypanel.setLayout(new BorderLayout(5, 20));

		//Add gadgets to panels
		lpanel.add(new JLabel("DATA REGISTERS                     OUTPUT               ADDRESS REGISTERS"));

		confirmgadgets.add(goButton = new JButton("Go!"));
		confirmgadgets.add(stepButton = new JButton("Step Through"));
		confirmgadgets.add(memdumpButton = new JButton("Show Memory"));
		confirmgadgets.add(resetButton = new JButton("Reset"));
		confirmgadgets.add(closeButton = new JButton("Close"));
		for (x =0; x<dregnum; x++)
		{
			dreglist[x] = new Register();
			dpanel.add(new JLabel("D"+new Integer(x)+":  "));
			dpanel.add(dreglist[x].getField());
		}
		for (x = 0;x<aregnum; x++)
		{
			areglist[x] = new Register();
			apanel.add(new JLabel("A"+new Integer(x) +":  "));
			apanel.add(areglist[x].getField());
		}
		ccrpanel.add(new JLabel(" C:"));
		ccrpanel.add(CCR.getCField());
		ccrpanel.add(new JLabel(" Z:"));
		ccrpanel.add(CCR.getZField());
		ccrpanel.add(new JLabel(" N:"));
		ccrpanel.add(CCR.getNField());
		ccrpanel.add(new JLabel(" V:"));
		ccrpanel.add(CCR.getVField());
		ypanel.add(scroll);
		ypanel.add(ccrpanel, "South");
		
		//Add buttons to the actionlistener
		goButton.addActionListener(this);
		closeButton.addActionListener(this);
		resetButton.addActionListener(this);
		stepButton.addActionListener(this);
		memdumpButton.addActionListener(this);

		//Add the panels to the main content pane
		contentpane.add(dpanel,"West");
		contentpane.add(ypanel, "Center");
		contentpane.add(apanel,"East");
		contentpane.add(lpanel,"North");
		contentpane.add(confirmgadgets,"South");
		sourcecode = new ParseSource(Prefs.getSourceFile(), model, areglist, dreglist, CCR);
	}



	/* Method to listen for events generated by gadgets
	** and act on them
	*/
    public void actionPerformed(ActionEvent evt)
    {

        Object source = evt.getSource();
        
		if (source == closeButton)
        {
            setVisible(false);
        }
		else
		{
			if (source == goButton)
			{
				sourcecode.go();
			}
		
        	else
        	{
				if (source == stepButton)
				{
					sourcecode.step();
				}
				else
				{
					if (source == resetButton)
					{
						reset();
					}
					else
					{
						if (source == memdumpButton)
						{
							sourcecode.memoryDump();
						}
						else
						{
            				setVisible(false);
						}
					}
				}
        	}
		}

	}

	/* Method to show the window and return the model so
	** so that additional text can be added to the listview
	*/
	public DefaultListModel showDia()
	{
		show();
		return model;
	}

	/*Method to reset the registers, memory locations and move to the start of the sourcecode*/
	public void reset()
	{
		int aregnum = StringToInt.strToInt(Prefs.getAreg());
		int dregnum = StringToInt.strToInt(Prefs.getDreg());
		int x;
		sourcecode.closeFile();
		sourcecode = new ParseSource(Prefs.getSourceFile(), model, areglist, dreglist, CCR);
		for (x =0; x<dregnum; x++)
		{
			dreglist[x].setValue(0);
		}
		for (x = 0;x<aregnum; x++)
		{
			areglist[x].setValue(0);
		}
		model.removeAllElements();
	}	

	private DefaultListModel model;
	private JButton closeButton;
	private JButton goButton;
	private JButton resetButton;
	private JButton stepButton;
	private JButton memdumpButton;
	private CCR CCR;
	private Register[] dreglist = new Register[32];
	private Register[] areglist = new Register[32];
	private ParseSource sourcecode;
}
