import java.awt.*;
import java.io.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import MyStack;
import Prefs;
import CentreObject;
import AboutDrawPanel;
import About;
import DefInstWin;
import DefRegWin;
import DefMemoryWin;
import RunSrcWin;
import ParseSource;
import StringToInt;
import Instruction;
import Register;
import MemoryLocation;
import Label;
import CCR;

/* Name: MainFrame
** Create the primary window including the menu system and graphics.
** Also implements a listening mechanism for the various menus.
*/
class MainFrame extends JFrame implements ActionListener
{
    public MainFrame()
    {
        //Variable Definitions
        contentPane = getContentPane();
        Toolkit tk = Toolkit.getDefaultToolkit();
		
        Image logo = tk.getImage("minilogo.gif");

        //Window Settings
        setTitle("UESA 1.0 by Ian Chapman");
        setSize(Prefs.getScrW(),Prefs.getScrH());
        setIconImage(logo);
        contentPane.add(new drawPanel());

        addWindowListener(new WindowAdapter()
            {
                public void windowClosing(WindowEvent e)
                {
                    System.exit(0);
                }
            });


        //Create The Menu Bar
        menuBar = new JMenuBar();
        setJMenuBar(menuBar);

        //Create Menus
        fileMenu = new JMenu("File");
        fileMenu.addActionListener(this);
		fileMenu.setMnemonic('F');
        configMenu = new JMenu("Configuration");
		configMenu.setMnemonic('C');
        helpMenu = new JMenu("Help");
		helpMenu.setMnemonic('H');

        //Create Menu Items
        opensourceItem = new JMenuItem("Open Source...", 'O');
        opensourceItem.addActionListener(this);
		opensourceItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, InputEvent.CTRL_MASK));
		opensourceItem.setIcon(new ImageIcon("open.gif"));
        runsourceItem = new JMenuItem("Run Source", 'R');
        runsourceItem.addActionListener(this);
		runsourceItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, InputEvent.CTRL_MASK));
        quitItem = new JMenuItem("Quit", 'Q');
        quitItem.addActionListener(this);
		quitItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, InputEvent.CTRL_MASK));
        //
        defmemItem = new JMenuItem("Define Memory Size", 'M');
        defmemItem.addActionListener(this);
		defmemItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_M, InputEvent.CTRL_MASK));
        defregItem = new JMenuItem("Define Registers", 'R');
        defregItem.addActionListener(this);
		defregItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E, InputEvent.CTRL_MASK));
        definstItem = new JMenuItem("Define Instruction Set", 'I');
        definstItem.addActionListener(this);
		definstItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_I, InputEvent.CTRL_MASK));
        //
        helpItem = new JMenuItem("Help", 'H');
        helpItem.addActionListener(this);
		helpItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_H, InputEvent.CTRL_MASK));
		helpItem.setIcon(new ImageIcon("help.gif"));
        aboutItem = new JMenuItem("About...", 'A');
        aboutItem.addActionListener(this);
		aboutItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_A, InputEvent.CTRL_MASK));

        //Join Items to Menus
        fileMenu.add(opensourceItem);
        fileMenu.add(runsourceItem);
        fileMenu.addSeparator();
        fileMenu.add(quitItem);
        //
        configMenu.add(defmemItem);
        configMenu.add(defregItem);
        configMenu.add(definstItem);
        //
        helpMenu.add(helpItem);
        helpMenu.add(aboutItem);

        //Join Menus to Menu Bar
        menuBar.add(fileMenu);
        menuBar.add(configMenu);
        menuBar.add(helpMenu);	
			
    }



	/* Method to listen for events generated by gadgets.
	*/
    public void actionPerformed(ActionEvent evt)
    {
		
        if (evt.getSource() instanceof JMenuItem)
        {
            String arg = evt.getActionCommand();
            if (arg.equals("Quit"))
            {
                System.exit(0);
            }
			else
			{
            	if (arg.equals("About..."))
            	{
                	aboutwin = new About(this);
                	aboutwin.show();
            	}
				else
				{
            		if (arg.equals("Open Source..."))
            		{
                		int result;
                		JFileChooser fr = new JFileChooser();
						File f = new File("sourcecode");
                		fr.setCurrentDirectory(f);
                		result=fr.showOpenDialog(this);
                		if (result==fr.APPROVE_OPTION)
						{
							f = fr.getSelectedFile();
							Prefs.setSourceFile(f.getAbsolutePath());
						}
                	}
					else
					{
						if (arg.equals("Define Memory Size"))
						{
							defmemwin = new DefMemoryWin(this);
							defmemwin.showDia();
						}
						else
						{
            				if (arg.equals("Define Registers"))
            				{
                				defregwin = new DefRegWin(this);
                				defregwin.showDia();
               
            				}
				            else
            				{
								if (arg.equals("Run Source"))
								{
									
									runsrcwin = new RunSrcWin(this);
									runsrcwin.showDia();
									
								}								
								else
								{
									if (arg.equals("Define Instruction Set"))
									{
										definstwin = new DefInstWin(this);
										definstwin.show();
										
									}
									else
									{
                						JOptionPane.showMessageDialog(this, "Please see the HTML documentation, included with this distribution.", "HELP", JOptionPane.INFORMATION_MESSAGE);
									}
								}            				
							}
						}
					}
				}
			}
        }
        else
		{
            System.out.println("NOT MENU");
		}

		repaint();
    }


    private JMenuBar menuBar;
    private JMenuItem opensourceItem;
    private JMenuItem runsourceItem;
    private JMenuItem quitItem;
    private JMenuItem defmemItem;
    private JMenuItem defregItem;
    private JMenuItem definstItem;
    private JMenuItem helpItem;
    private JMenuItem aboutItem;
    private JMenu configMenu;
    private JMenu helpMenu;
    private JMenu fileMenu;
    private About aboutwin;
    private DefRegWin defregwin;
	private DefMemoryWin defmemwin;
	private RunSrcWin runsrcwin;
	private DefInstWin definstwin;
    private String areg;
    private String dreg;
	private Container contentPane;
}

/* Initialises the preferences with the screen settings then opens
** the main window
*/
public class UESA
{
    public static void main(String[] args)
    {
		cr();
		Toolkit tk = Toolkit.getDefaultToolkit();
    	Dimension screensize = tk.getScreenSize();
		Prefs.setScreenSize(screensize.width, screensize.height);
        JFrame frame = new MainFrame();		
        frame.show();
		frame.repaint();
    }

	/*
	Function Type:			Op type:
	ADD 	= 0				LITERAL	= 0
	SUB		= 1				D REG	= 1
	MULU	= 2				A REG	= 2
	DIV		= 3				MEM LOC = 3
	MOVE 	= 4				LABEL	= 4
	JMP		= 5
	SGT		= 6
	SLT		= 7
	BINZ	= 8
	BIZ	    = 9
	CMP	    = 10
	*/


	public  static void cr()
	{
		int[] a = new int[5];
		int[] b = new int[5];

		a[0] = ADDRREG;
		a[1] = DATAREG;
		b[0] = MOV;

		Prefs.newInst("MOVE.DA", 2,1, a, b);

		a[0] = DATAREG;
		a[1] = ADDRREG;
		b[0] = MOV;

		Prefs.newInst("MOVE.AD", 2, 1, a, b);


		a[0] = LITERAL;
		a[1] = MEMLOCA;
		b[0] = MOV;

		Prefs.newInst("MOVE.ML", 2, 1, a, b);

		a[0] = LITERAL;
		a[1] = ADDRREG;
		b[0] = MOV;

		Prefs.newInst("MOVE.AL", 2,1, a, b);

		a[0] = LITERAL;
		a[1] = DATAREG;
		b[0] = MOV;

		Prefs.newInst("MOVE.DL", 2,1, a, b);

		a[0] = MEMLOCA;
		a[1] = DATAREG;
		b[0] = MOV;

		Prefs.newInst("MOVE.DM", 2,1, a, b);

		a[0] = LITERAL;
		a[1] = LITERAL;
		a[2] = DATAREG;
		b[0] = ADD;
		b[1] = MOV;

		Prefs.newInst("ADD.DLL", 3, 2 , a, b);				
		
		a[0] = LITERAL;
		a[1] = DATAREG;
		a[2] = DATAREG;
		b[0] = ADD;
		b[1] = MOV;

		Prefs.newInst("ADD.DDL", 3, 2 , a, b);

		a[0] = LITERAL;
		a[1] = LITERAL;
		a[2] = DATAREG;
		b[0] = SUB;
		b[1] = MOV;

		Prefs.newInst("SUB.DLL", 3, 2 , a, b);
		
		a[0] = LITERAL;
		a[1] = LITERAL;
		a[2] = DATAREG;
		b[0] = MUL;
		b[1] = MOV;


		Prefs.newInst("MULU.DLL", 3, 2, a, b);

		a[0] = DATAREG;
		a[1] = DATAREG;
		a[2] = DATAREG;
		b[0] = MUL;
		b[1] = MOV;

		Prefs.newInst("MULU.DDD", 3, 2, a, b);

		a[0] = LITERAL;
		a[1] = LITERAL;
		a[2] = DATAREG;
		b[0] = DIV;
		b[1] = MOV;

		Prefs.newInst("DIV.DLL", 3, 2, a, b);

		a[0] = LABEL;
		b[0] = JMP;

		Prefs.newInst("JMP", 1, 1, a, b); 

		a[0] = LABEL;
		b[0] = BINZ;

		Prefs.newInst("BINZ", 1, 1, a, b);

		a[0] = LABEL;
		b[0] = BIZ;

		Prefs.newInst("BIZ", 1, 1, a, b);

		a[0] = LITERAL;
		a[1] = LITERAL;
		b[0] = CMP;

		Prefs.newInst("CMP.LL", 2, 1, a, b);

		a[0] = DATAREG;
		a[1] = DATAREG;
		b[0] = SLT;

		Prefs.newInst("SLT.DD", 2, 1, a, b);

		a[0] = LITERAL;
		a[1] = LITERAL;
		b[0] = SLT;

		Prefs.newInst("SLT.LL", 2, 1, a, b);

		a[0] = LITERAL;
		a[1] = LITERAL;
		b[0] = SGT;

		Prefs.newInst("SGT.LL", 2, 1, a, b);

		a[0] = DATAREG;
		a[1] = DATAREG;
		b[0] = SGT;

		Prefs.newInst("SGT.DD", 2, 1, a, b);

	}
	private static final int ADD = 0;
	private static final int SUB = 1;
	private static final int MUL = 2;
	private static final int DIV = 3;
	private static final int MOV = 4;
	private static final int JMP = 5;
	private static final int SGT = 6;
	private static final int SLT = 7;
	private static final int BINZ = 8;
	private static final int BIZ = 9;
	private static final int CMP = 10;
	private static final int LITERAL = 0;
	private static final int DATAREG = 1;
	private static final int ADDRREG = 2;
	private static final int MEMLOCA = 3;
	private static final int LABEL = 4;
 
}
