use z80disasm;
use Data::Dumper;
use strict;

$ARGV[0] ||= 'ftest13.bin';	# test

open(IN, "<", "$ARGV[0]") || die "$!";
binmode(IN);

# Einlesen
$buffer = '';
until (eof IN) {
	read IN, $_, 0x1000;
	$buffer .= $_;	
}
close IN;

#testmode for debugger
#$z80disasm::debugm = 1;


# first pass
%z80disasm::marks = ();
$z80disasm::addresses = ();
$offset = 0x8000;	# program offset
$ptr = -1;
$address = $offset;

$pass = 1;
while ($ptr < length($buffer)-1 )
{
    decode();
}
my $lastaddress = $address;


#print Dumper(\%z80disasm::marks);
# Marken auerhalb Programmbereich lschen
$offset = 0x8000;
foreach (keys %z80disasm::marks) {
	unless ($_ >= $offset and $_ <= $lastaddress) {
		$z80disasm::marks{$_} = sprintf("0%.4Xh", $_);
	}
}

#print Dumper(\%z80disasm::addresses);
# ungltige Marken lschen
foreach (keys %z80disasm::marks) {
	unless (exists $z80disasm::addresses{$_}) {
		$z80disasm::marks{$_} = sprintf("0%.4Xh", $_);
	}
}

# last pass
# print assembly
# the code is for the arnold assembler as (http://john.ccac.rwth-aachen.de:8000/as/)
$offset = 0x8000;
$ptr = -1;
$address = $offset;
$pass = 0;

print  "		cpu	z80\n";
printf "		org	%.5Xh\n\n", $offset;
while ($ptr < length($buffer)-1 ) {
    decode();
}
print "\n		end\n";

