#!/usr/bin/env python
# Copyright (C) 2008 Ian Chapman
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import sys
# Convenience for running from this directory.
sys.path.append("../modules")
from tzx import *
from zxfile import *

################################################################################
# EXAMPLE 2 - Pure python script that generates a turbo TZX file to load a     #
#             screen.                                                          #
#                                                                              #
# A revised version of example 1 which loads the spectrum screen through using #
# a custom sprectrum loading routine. We have three spectrum files, the first  #
# is the basic program which boot straps the second file, which is the custom  #
# loading routine. The custom loading routine itself then loads then loads the #
# actual screen data. As the screen data is headerless, we need *5* TZX blocks #
################################################################################

# Main code starts around line 473

# A packed string representation of spectrum screen data
screenbytes = \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x55\x55\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x01\x55\x55\x55\x55\x55\x55\x55\x55\x55\x54" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x15\x50\x00\x01\x55\x55\x55\x55\x55\x55\x55\x50\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x15\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x55\x55\x55\x55\x55\x50\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x55\x55\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x01\x11\x11\x11\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x55\x55\x55\x55\x55\x55\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x50\x01\x11\x11\x11\x15\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xAA\xAA\xBB\xBA\xAA" \
    "\xAA\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x0A\xAA\xAA\xBB\xBB\xBB\xBB\xBB\xBB\xBB" \
    "\xBB\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x2A\xA8\x00\x02\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xA8" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x3B\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xB8\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\xBB\xBB\xBB\xBB\xBB\xB8\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\xAA\xAB\xBB\xBB\xBB" \
    "\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xB8\x02\xAA\xAA\xAA\xA0\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x02\xAA\xBB\xBB\xBB\xBB\xBB\xBB\xBB" \
    "\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xB8\x0A\xAA\xAA\xAA\xAA\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x55\x55\x55\x55" \
    "\x55\x55\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x05\x55\x40\x15\x55\x55\x55\x55\x55" \
    "\x55\x55\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x15\x50\x00\x01\x55\x55\x55\x55\x55\x55\x55" \
    "\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x15\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x55\x55\x55\x55\x55\x50\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x55\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x04\x45\x55\x55\x40" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x55\x55\x55\x55\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x05\x55\x55\x55\x55\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xAE\xEE\xEE\xEE" \
    "\xEE\xEE\xEE\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\xEE\x00\x0E\xEE\xEE\xEE\xEE" \
    "\xEE\xEE\xEE\xC0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x2E\xE8\x00\x02\xEE\xEE\xEE\xEE\xEE\xEE" \
    "\xEE\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x2E\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xE8" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\xEE\xEE\xEE\xEE\xEE\xE8\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\xEE\xEE\xEE" \
    "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xE8\x0A\xAA\xAA\xAA" \
    "\xA8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\xEE\xEE\xEE\xEE\xEE\xEE" \
    "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xE8\x0A\xAA\xAA\xAA\xAA\x80" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x54\x00\x05\x55\x55\x55" \
    "\x55\x55\x55\x55\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x15\x50\x00\x01\x55\x55\x55\x55\x55" \
    "\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x15\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55" \
    "\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x55\x55\x55\x55\x55\x50\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x01\x11\x11" \
    "\x11\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x55\x55\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x01\x11\x11\x15\x55" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2A\xAA\xAB" \
    "\xBB\xBB\xBB\xBB\xBB\xBA\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xA8\x00\x03\xBB\xBB" \
    "\xBB\xBB\xBB\xBB\xBB\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2B\xBA\x00\x0B\xBB\xBB\xBB\xBB" \
    "\xBB\xBB\xBB\xB8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x3B\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB" \
    "\xBB\xB8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xBB\xBB\xBB\xBB\xBB\xB8" \
    "\x02\xAA\xAA\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2A\xAA" \
    "\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xB8\x0A\xAA" \
    "\xAA\xAA\xAA\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xBB\xBB\xBB\xBB" \
    "\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xA8\x0A\xAA\xAA\xAA" \
    "\xAA\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x50\x00\x01\x55" \
    "\x55\x55\x55\x55\x55\x55\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x00\x15\x55\x55\x55" \
    "\x55\x55\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55\x55\x55\x55\x55\x55\x55" \
    "\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x01\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55" \
    "\x50\x04\x44\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x04" \
    "\x45\x55\x55\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x05\x55\x55" \
    "\x55\x55\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\xEE" \
    "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xE8\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\xE8\x00\x02" \
    "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2E\xEE\xAA\xAE\xEE\xEE" \
    "\xEE\xEE\xEE\xEE\xEE\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2E\xEE\xEE\xEE\xEE\xEE\xEE\xEE" \
    "\xEE\xEE\xEE\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x2E\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE" \
    "\xEE\xE8\x0A\xAA\xAA\xAA\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xE8" \
    "\x0A\xAA\xAA\xAA\xAA\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0E\xEE\xEE" \
    "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xE0\x0A\xAA" \
    "\xAA\xAA\xAA\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x05\x55\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x11\x11\x15\x55" \
    "\x55\x40\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55\x55\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x00\x01\x11\x15\x55\x55\x55\x50" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x55\x55\x55\x55\x55\x55\x55\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x11\x11\x15\x55\x55\x55\x55\x50\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x15\x55\x55\x55\x55\x54\x00\x00\x00\x01\x11" \
    "\x11\x11\x11\x11\x11\x11\x55\x55\x55\x55\x55\x55\x50\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x05\x55\x55\x55\x55\x40\x00\x00\x11\x11\x11\x11\x11" \
    "\x11\x11\x55\x55\x55\x55\x55\x55\x55\x55\x40\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x55\x55\x55\x55\x40\x01\x11\x11\x11\x11\x11\x11\x11\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x05\x55\x55\x40\x11\x11\x11\x11\x11\x11\x55\x55\x55\x55\x55" \
    "\x55\x55\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x11\x11\x11\x11\x11\x55\x55\x55\x55\x55\x55\x50\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0B\xBB\xBB\xBB" \
    "\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xA0\x0A\xAA\xAA" \
    "\xAA\xAA\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x3B\xBB\xBB\xBB\xBB\xBB" \
    "\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\x00\x02\xAA\xAA\xAA\xAA\xAA" \
    "\xA8\x00\x00\x00\x00\x00\x00\x00\x00\x3B\xBB\xBB\xBB\xBB\xBB\xBA\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x02\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xA8\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x3B\xBB\xBB\xBB\xBB\xBA\x02\xAA\xAA\xAA" \
    "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xA8\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x03\xBB\xBB\xBB\xBB\xA0\x0A\xAA\xAA\xAA\xAA\xAA" \
    "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAB\xBB\x80\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x3B\xBB\xBB\xBB\xA0\x0A\xAA\xAA\xAA\xAA\xAA\xAA\xAA" \
    "\xAA\xAA\xAA\xAA\xAA\xAA\xBB\xBB\xB8\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x2B\xBB\xA0\x0A\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA" \
    "\xAA\xAA\xAB\xBB\xBA\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x0A\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xB8" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x40\x15\x55" \
    "\x55\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x55\x55\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x00\x05\x55\x55\x55\x55" \
    "\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x55\x55\x55\x55\x55\x55\x54" \
    "\x00\x04\x44\x44\x44\x44\x44\x55\x55\x55\x55\x55\x55\x55\x55\x55\x54" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55\x55\x55\x50\x00\x44\x44" \
    "\x44\x44\x44\x45\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x05\x55\x55\x55\x55\x40\x04\x44\x44\x44\x44" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x40\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x15\x55\x55\x55\x40\x04\x44\x44\x44\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x44\x45\x55\x55\x54\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x04\x45\x55\x55\x55\x55\x55\x55\x55\x55\x55" \
    "\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2E\xEE" \
    "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xC0\x2A" \
    "\xAA\xAA\xAA\xAA\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x6E\xEE\xEE\xEE" \
    "\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xE8\x00\x2A\xAA\xAA\xAA" \
    "\xAA\xAE\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x2E\xEE\xEE\xEE\xEE\xEE" \
    "\xE0\x00\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAE\xEE" \
    "\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x2E\xEE\xEE\xEE\xEE\xE8\x02\xAA" \
    "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAE\xEE\xEE\xEE\xE8\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x02\xEE\xEE\xEE\xEE\xE0\x0A\xAA\xAA\xAA" \
    "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xEE\xEE\xEE\xEE\xEE\x80\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x0E\xEE\xEE\xEE\xE0\x0A\xAA\xAA\xAA\xAA\xAA" \
    "\xAA\xAA\xAA\xAA\xAE\xEE\xEE\xEE\xEE\xEE\xE8\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xAA\xAA\xAA\xAA\xAA\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x0A\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xEE\xEE" \
    "\xEE\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x00" \
    "\x11\x11\x55\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x55\x55\x55" \
    "\x55\x55\x55\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x11\x15\x55" \
    "\x55\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55\x55\x55" \
    "\x55\x40\x00\x00\x00\x01\x11\x11\x11\x11\x11\x11\x15\x55\x55\x55\x55" \
    "\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x05\x55\x55\x55\x55\x50\x00" \
    "\x00\x00\x11\x11\x11\x11\x11\x11\x11\x55\x55\x55\x55\x55\x55\x55\x50" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x01\x55\x55\x55\x55\x40\x00\x01\x11" \
    "\x11\x11\x11\x11\x11\x15\x55\x55\x55\x55\x55\x55\x55\x55\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x05\x55\x55\x55\x40\x11\x11\x11\x11\x11" \
    "\x11\x11\x55\x55\x55\x55\x55\x55\x55\x55\x55\x40\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x11\x11\x11\x11\x14\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x11\x11\x11\x11\x55\x55\x55\x55\x55" \
    "\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x3B\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBA" \
    "\x00\x2A\xAA\xAA\xAA\xAA\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x3B\xBB" \
    "\xBB\xBB\xBB\xBB\xBB\xBA\x80\x00\x00\x00\x00\x00\x00\x00\x00\xAA\xAA" \
    "\xAA\xAA\xAA\xAA\xA8\x00\x00\x00\x00\x00\x00\x00\x00\x3B\xBB\xBB\xBB" \
    "\xBB\xBB\x80\x02\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA" \
    "\xAA\xAA\xA8\x00\x00\x00\x00\x00\x00\x00\x00\x0B\xBB\xBB\xBB\xBB\xA0" \
    "\x0A\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAB" \
    "\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x02\xBB\xBB\xBB\xBB\xA0\x0A\xAA" \
    "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xBB\xBB\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x03\xBB\xBB\xBB\xA0\x0A\xAA\xAA\xAA" \
    "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAB\xBB\xBB\x80\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xAA\xAA\xAA\xAA\xAA" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xAA\xAA\xAA\xAA\xAA\xAA\xAA" \
    "\xAA\xAA\xAB\xB8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x15\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55" \
    "\x54\x00\x55\x55\x55\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x55" \
    "\x55\x55\x55\x55\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x05\x55" \
    "\x55\x55\x55\x55\x55\x54\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55" \
    "\x55\x55\x55\x00\x04\x44\x44\x44\x44\x44\x45\x55\x55\x55\x55\x55\x55" \
    "\x55\x55\x55\x54\x00\x00\x00\x00\x00\x00\x00\x00\x05\x55\x55\x55\x55" \
    "\x40\x04\x44\x44\x44\x44\x44\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55" \
    "\x55\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x55\x55\x55\x40\x04" \
    "\x44\x44\x44\x45\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x54\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x55\x55\x40\x04\x44\x44" \
    "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x45\x55\x55\x55" \
    "\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55\x55\x55\x55\x55" \
    "\x55\x55\x55\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x2E\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE\xEE" \
    "\xEE\xE8\x00\xAA\xAA\xAA\xAA\xAA\xE8\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x6E\xEE\xEE\xEE\xEE\xEE\xEE\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x0A" \
    "\xAA\xAA\xAA\xAA\xAE\xEE\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x2E\xEE" \
    "\xEE\xEE\xEE\xEE\x00\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA" \
    "\xAA\xEE\xEE\xEE\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x0E\xEE\xEE\xEE" \
    "\xEE\xE0\x0A\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAE\xEE\xEE" \
    "\xEE\xEE\xE0\x00\x00\x00\x00\x00\x00\x00\x00\x00\xEE\xEE\xEE\xEE\xE0" \
    "\x0A\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xEE\xEE\xEE\xEE\xEE\xEE" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2E\xEE\xEE\xE0\x0A\xAA" \
    "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xAE\xEE\xEE\xEE\xEE\xEE\xE8\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xAA\xAA\xAA" \
    "\xAA\xAA\xAA\xAA\xAA\xAA\xAA\xA8\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xAA\xAA\xAA\xAA\xAA" \
    "\xAA\xAE\xE8\x02\xEE\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x11\x11\x15\x55\x55\x55\x55" \
    "\x40\x00\x55\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x01\x11\x55\x55\x55\x55\x55\x55\x00\x00" \
    "\x15\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x01\x55\x55\x55\x55\x55\x55\x55\x55\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xAA\xAA\xAA\xAA\xAA\xAA" \
    "\xAA\x80\x00\xBB\xB8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xAA\xAA\xAA\xAA\xAA\xAA\xAA\x80" \
    "\x00\x3B\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\xAA\xAA\xAA\xAA\xAA\xAB\xBB\xBA\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55\x55\x55\x55" \
    "\x55\x55\x00\x00\x15\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x55\x55\x55\x55\x55\x55\x55" \
    "\x40\x00\x55\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05\x55\x55\x55\x55\x55\x55\x54" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xAA\xAA\xAA\xAA" \
    "\xAA\xAE\xEE\x00\x00\x2E\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\xAA\xAA\xAA\xAA\xEE\xEE" \
    "\xEE\xE8\x02\xEE\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xAE\xEE\xEE\xEE\xEE\xEE" \
    "\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x11\x11\x55" \
    "\x55\x55\x55\x55\x00\x00\x15\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55\x55\x55" \
    "\x55\x55\x55\x15\x55\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55\x55\x55" \
    "\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xAA\xAA" \
    "\xAA\xAA\xAA\xAA\xAA\x00\x00\x2B\xA8\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xAA\xAA\xAA\xAA" \
    "\xAA\xAA\xAA\xBB\xBB\xBA\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\xAA\xAA\xAB" \
    "\xBA\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55" \
    "\x55\x55\x55\x55\x55\x55\x00\x00\x15\x50\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x15\x55\x55" \
    "\x55\x55\x55\x55\x55\x55\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04" \
    "\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A" \
    "\xAA\xAA\xAA\xAA\xAA\xEE\xEE\x00\x00\x2E\xE0\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A\xAA" \
    "\xAA\xEE\xEE\xEE\xEE\xEE\xEE\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x08\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
    "\x00\x00\x00\x00\x00\x00\x00\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x3D\x3D" \
    "\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x3D\x3D\x3D\x3D" \
    "\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x3D\x3D\x3D\x3D\x3D\x3D" \
    "\x3D\x3D\x3D\x3D\x3D\x3D\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D" \
    "\x3D\x3D\x3D\x3D\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D" \
    "\x3D\x3D\x3E\x3E\x3E\x3E\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D" \
    "\x3E\x3E\x3E\x3E\x3E\x38\x38\x38\x38\x38\x38\x38\x38\x38\x3D\x3D\x3D" \
    "\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3E\x3E" \
    "\x3E\x3E\x3E\x3E\x38\x38\x38\x38\x38\x38\x38\x38\x3D\x3D\x3D\x3D\x3D" \
    "\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3E\x3E\x3E\x3E" \
    "\x3E\x3E\x38\x38\x38\x38\x38\x38\x38\x38\x3D\x3D\x3D\x3D\x3D\x3D\x3D" \
    "\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x3D\x3D\x3D\x3D\x3D\x3D\x3D\x3E\x3E" \
    "\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x3D\x3D\x3D\x3D\x3D\x3D\x3E\x3E\x3E\x3E\x3E" \
    "\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x3D\x3D\x3D\x3D\x3D\x3D\x3E\x3E\x3E\x3E\x3E\x3E\x3E" \
    "\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x3D\x3D\x3D\x3D\x3D\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E" \
    "\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x3D\x3D\x3D\x3D\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E" \
    "\x3E\x3E\x3E\x3E\x3E\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x38\x3E\x3E\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x3E" \
    "\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x3E\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38" \
    "\x38\x38\x38\x38\x38\x38\x38\x38\x38\x38"

# A packed string representation of a tokenised Spectrum Basic Program
# 10 CLEAR 34999
# 20 LOAD "" CODE
# 30 RANDOMIZE USR 35000
basicprog = \
    "\x00\x0A\x0D\x00\xFD\x33\x34\x39\x39\x39\x0E\x00\x00\xB7\x88\x00\x0D" \
    "\x00\x14\x05\x00\xEF\x22\x22\xAF\x0D\x00\x1E\x0E\x00\xF9\xC0\x33\x35" \
    "\x30\x30\x30\x0E\x00\x00\xB8\x88\x00\x0D\x77"

# A packed string representation of a machine code program, the custom
# loader (from Turbo Maker by Lee Tonks)
turboprog = \
    "\xDD\x21\x00\x40\x11\x00\x1B\x3E\xFF\x37\xCD\xC6\x88\xC9\x14\x08\x15" \
    "\xF3\x3E\x0F\xD3\xFE\x21\x3F\x05\xE5\xDB\xFE\x1F\xE6\x20\xF6\x02\x4F" \
    "\xBF\xC0\xCD\x57\x89\x30\xFA\x21\x15\x04\x10\xFE\x2B\x7C\xB5\x20\xF9" \
    "\xCD\x53\x89\x30\xEB\x06\x9C\xCD\x53\x89\x30\xE4\x3E\xC6\xB8\x30\xE0" \
    "\x24\x20\xF1\x06\xC9\xCD\x57\x89\x30\xD5\x78\xFE\xD4\x30\xF4\xCD\x57" \
    "\x89\xD0\x79\xEE\x03\x4F\x26\x00\x06\xB0\x18\x1F\x08\x20\x07\x30\x0F" \
    "\xDD\x75\x00\x18\x0F\xCB\x11\xAD\xC0\x79\x1F\x4F\x13\x18\x07\xDD\x7E" \
    "\x00\xAD\xC0\xDD\x23\x1B\x08\x06\xB2\x2E\x01\xCD\x53\x89\xD0\x3E\xBD" \
    "\xB8\xCB\x15\x06\xB0\xD2\x3A\x89\x7C\xAD\x67\x7A\xB3\x20\xCA\x7C\xFE" \
    "\x01\xC9\xCD\x57\x89\xD0\x3E\x16\x3D\x20\xFD\xA7\x04\xC8\x3E\x7F\xDB" \
    "\xFE\x1F\x00\xA9\xE6\x20\x28\xF3\x79\x2F\x4F\xE6\x0A\xF6\x08\xD3\xFE" \
    "\x37\xC9"


# Before dealing with the TZX file itself, we can use some spectrum specific
# classes and methods to create the data that needs to encapsulated into a
# TZX block and added to a TZX.

# First file: The spectrum basic "loader"
# CREATE THE HEADER
# For an explanation of the parameters, see zxfile.py
loaderheader = ZX_FileHdr(SPEC_FILE_PROG, 'LoadTurbo', 0, 10, 44)

# CREATE THE DATA and incorporate our basic program
loaderdata = ZX_FileData(basicprog)

# Tell the header, the size of the data.
loaderheader.setdatalen(loaderdata.datalen())


# Second File: The spectrum "Turbo Loader"
# CREATE THE HEADER
# For an explanation of the parameters, see zxfile.py
tloaderheader = ZX_FileHdr(SPEC_FILE_CODE, 'Turbo', 0, 35000, 32768)

# CREATE THE DATA and incorporate our machine code program
tloaderdata = ZX_FileData(turboprog)

# Tell the header, the size of the data.
tloaderheader.setdatalen(tloaderdata.datalen())


# Third File: The screen data (this is code ie "Bytes:")
# THIS FILE IS HEADERLESS SO ONLY CREATE THE DATA
screendata = ZX_FileData(screenbytes)


# Now that we have prepared our spectrum files, they need to be incorporated
# into TZX blocks. We will be using the "Standard Speed Data Block" for the
# basic loader and the the turbo loader but the screen data needs to be in a
# "Turbo Speed Data Block"

# Incorporate the loader header into a TZX block.
loaderblock1 = Blk_SSDB(data=loaderheader.get())

# Incorporate the loader data into a TZX block.
loaderblock2 = Blk_SSDB(data=loaderdata.get())

# Incorporate the turbo loader header into a TZX block.
tloaderblock1 = Blk_SSDB(data=tloaderheader.get())

# Incorporate the turbo loader data into a TZX block.
tloaderblock2 = Blk_SSDB(data=tloaderdata.get())

# Incorporate the screen's data into a TZX block.
# For the parameters, see tzx.py
screenblock = Blk_TSDB(data=screendata.get())
# Set various timing values for the turbo speed block
screenblock.syncpulse1(714)
screenblock.syncpulse2(714)
screenblock.bitpulse0(573)
screenblock.bitpulse1(1147)


# Now we create a new TZX layout and add the TZX blocks to it in the order that
# you want them to appear on the tape.
logotape = TZX()
logotape.add_block(loaderblock1)
logotape.add_block(loaderblock2)
logotape.add_block(tloaderblock1)
logotape.add_block(tloaderblock2)
logotape.add_block(screenblock)


# Almost complete, the final stage is to write the TZX to a file.
tzxfile = open('turbopylogo.tzx', 'wb')
logotape.write(tzxfile)
tzxfile.close()

# The resulting tzx file should load and run in an emulator!